USE [ProSolutionReports]
GO


SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

/*
--Sample Import View for Use with OneGrade
--For use with ProSolution
--For OneGrade Version 1.23 onwards
*/

CREATE VIEW [dbo].[vOG_StaffUser]
AS
 
SELECT TOP 100 PERCENT
LEFT(ProSolution.dbo.Staff.StaffRefNo,24) AS StaffCode, 
LEFT(ProSolution.dbo._CCC_SystemUser.UserName,50) AS UserName,
LEFT(ProSolution.dbo.Staff.Title,50) As Title, 
LEFT(CASE WHEN ProSolution.dbo.Staff.KnownAs IS NULL THEN ProSolution.dbo.Staff.FirstName ELSE ProSolution.dbo.Staff.KnownAs END,100) AS Forenames, 
LEFT(ProSolution.dbo.Staff.Surname,100) AS Surname,
LEFT(ProSolution.dbo._CCC_SystemUser.EmailAddress,100) AS Email,
LEFT(ProSolution.dbo.Staff.MobileTel,15) AS MobileTel


FROM
ProSolution.dbo.Staff WITH (NOLOCK) INNER JOIN
	ProSolution.dbo._CCC_SystemUser WITH (NOLOCK)
	ON ProSolution.dbo.Staff.SystemUserID = ProSolution.dbo._CCC_SystemUser.SystemUserID
	INNER JOIN
		(
		SELECT Max(ProSolution.dbo.Staff.StaffID) AS MaxStaffID
		FROM ProSolution.dbo.Staff WITH (NOLOCK)
			INNER JOIN ProSolution.dbo._CCC_SystemUser WITH (NOLOCK)
			ON ProSolution.dbo.Staff.SystemUserID = ProSolution.dbo._CCC_SystemUser.SystemUserID
		WHERE 
		(ProSolution.dbo.Staff.IsCurrent = 1)
		AND LEN(ProSolution.dbo._CCC_SystemUser.UserName) > 0
		GROUP BY 
		ProSolution.dbo.Staff.SystemUserID
		) MaxStaff
			ON MaxStaff.MaxStaffID = ProSolution.dbo.Staff.StaffID
WHERE ProSolution.dbo._CCC_SystemUser.IsLockedout = 0

GO


